/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import com.james.tinkerscalibration.modifiers.DarknessModifier;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;

public class ArmorDarknessModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> DARKNESS = TConstruct.createKey((String)"darkness_armor");

    public ArmorDarknessModifier() {
        MinecraftForge.EVENT_BUS.addListener(ArmorDarknessModifier::onUpdateApply);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(DARKNESS, false, null));
    }

    private static void onUpdateApply(LivingEvent.LivingTickEvent evt) {
        EquipmentContext context;
        LivingEntity living = evt.getEntity();
        if (!living.m_5833_() && (context = new EquipmentContext(living)).hasModifiableArmor() && !living.f_19853_.f_46443_) {
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
                int light;
                int levels = (Integer)holder.get(DARKNESS, (Object)0);
                if (levels > 0 && (light = DarknessModifier.getLight(living.m_9236_(), living.m_20183_())) <= 9 && (living.m_21023_(MobEffects.f_19606_) && living.m_21124_(MobEffects.f_19606_).m_19557_() <= 100 || !living.m_21023_(MobEffects.f_19606_))) {
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200));
                }
            });
        }
    }
}

